CREATE TABLE users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  tg_id BIGINT UNIQUE NOT NULL,
  username VARCHAR(255),
  first_name VARCHAR(255),
  last_name VARCHAR(255),
  is_member TINYINT(1) DEFAULT 0,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE payments (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  tg_id BIGINT NOT NULL,
  amount DECIMAL(10,2) NOT NULL,
  card_to_card_to VARCHAR(64),
  status ENUM('pending','confirmed','rejected') DEFAULT 'pending',
  txn_info TEXT,
  receipt_photo_file_id VARCHAR(255),
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  confirmed_at TIMESTAMP NULL,
  FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

CREATE TABLE settings (
  `key` VARCHAR(100) PRIMARY KEY,
  `value` TEXT
);

INSERT INTO settings (`key`,`value`) VALUES
('card_number','6037-xxxx-xxxx-xxxx'),
('monthly_fee','50000'),
('admin_tg_id','123456789');
