<?php
$config = require __DIR__ . '/config.php';
$token = $config['bot_token'];
$apiBase = "https://api.telegram.org/bot{$token}/";

try {
    $pdo = new PDO($config['db']['dsn'], $config['db']['user'], $config['db']['pass'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
} catch (Exception $e) {
    error_log("DB error: " . $e->getMessage());
    exit;
}

$raw = file_get_contents('php://input');
if ($raw) {
    $update = json_decode($raw, true);
    if ($update) handleUpdate($update, $pdo, $apiBase);
} else {
    echo "Bot is running.";
}

function handleUpdate($update, $pdo, $apiBase) {
    if (isset($update['message'])) {
        $msg = $update['message'];
        $chat_id = $msg['chat']['id'];
        $from = $msg['from'];
        $text = $msg['text'] ?? '';

        // ثبت کاربر
        $stmt = $pdo->prepare("SELECT * FROM users WHERE tg_id = ?");
        $stmt->execute([$from['id']]);
        $user = $stmt->fetch();
        if (!$user) {
            $ins = $pdo->prepare("INSERT INTO users (tg_id, username, first_name, last_name) VALUES (?, ?, ?, ?)");
            $ins->execute([$from['id'], $from['username'] ?? null, $from['first_name'] ?? null, $from['last_name'] ?? null]);
            $user_id = $pdo->lastInsertId();
        } else $user_id = $user['id'];

        // /start
        if ($text === '/start') {
            sendMessage($apiBase, $chat_id, "سلام {$from['first_name']}!
برای خرید اشتراک /buy بزن.");
            return;
        }

        // /buy
        if ($text === '/buy') {
            $card = getSetting($pdo, 'card_number');
            $fee = getSetting($pdo, 'monthly_fee') ?: '0';
            $reply = "لطفاً مبلغ {$fee} تومان را به کارت زیر کارت‌به‌کارت کنید:

شماره کارت: <code>{$card}</code>

سپس با دستور /confirm شماره پیگیری یا ارسال عکس رسید، پرداخت را ثبت کنید.";
            sendMessage($apiBase, $chat_id, $reply, 'HTML');
            return;
        }

        // تایید پرداخت (متن یا عکس)
        if (strpos($text, '/confirm') === 0 || isset($msg['photo'])) {
            $info = null; $photo_id = null;
            if (isset($msg['photo'])) {
                $largest = end($msg['photo']);
                $photo_id = $largest['file_id'];
                $info = $msg['caption'] ?? "رسید تصویری";
            } else {
                $parts = explode(' ', $text, 2);
                $info = $parts[1] ?? null;
            }

            if (!$info && !$photo_id) {
                sendMessage($apiBase, $chat_id, "لطفاً پس از /confirm اطلاعات تراکنش یا عکس رسید را ارسال کنید.");
                return;
            }

            $card = getSetting($pdo, 'card_number');
            $fee = getSetting($pdo, 'monthly_fee') ?: 0;
            $ins = $pdo->prepare("INSERT INTO payments (user_id, tg_id, amount, card_to_card_to, txn_info, receipt_photo_file_id, status) VALUES (?, ?, ?, ?, ?, ?, 'pending')");
            $ins->execute([$user_id, $from['id'], $fee, $card, $info, $photo_id]);

            sendMessage($apiBase, $chat_id, "درخواست پرداخت ثبت شد و پس از بررسی ادمین اطلاع‌رسانی می‌شود.");
            $admin_tg = getSetting($pdo, 'admin_tg_id');
            if ($admin_tg) {
                $pid = $pdo->lastInsertId();
                $textAdmin = "📥 پرداخت جدید:
کاربر: {$from['first_name']} ({$from['id']})
مبلغ: {$fee}
اطلاعات: {$info}

/approve_payment {$pid} | /reject_payment {$pid}";
                sendMessage($apiBase, $admin_tg, $textAdmin);
                if ($photo_id) sendPhoto($apiBase, $admin_tg, $photo_id, "رسید پرداخت #{$pid}");
            }
            return;
        }
    }
}

function sendMessage($apiBase, $chat_id, $text, $parse_mode=null) {
    $data = ['chat_id'=>$chat_id,'text'=>$text];
    if ($parse_mode) $data['parse_mode']=$parse_mode;
    file_get_contents($apiBase."sendMessage?".http_build_query($data));
}

function sendPhoto($apiBase, $chat_id, $file_id, $caption=null) {
    $data = ['chat_id'=>$chat_id,'photo'=>$file_id];
    if ($caption) $data['caption']=$caption;
    $ch=curl_init();
    curl_setopt($ch,CURLOPT_URL,$apiBase."sendPhoto");
    curl_setopt($ch,CURLOPT_POST,1);
    curl_setopt($ch,CURLOPT_POSTFIELDS,$data);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_exec($ch); curl_close($ch);
}

function getSetting($pdo,$key){
    $s=$pdo->prepare("SELECT value FROM settings WHERE `key`=?");$s->execute([$key]);$r=$s->fetch();return $r?$r['value']:null;
}
?>
